 /* 'mrWindows.cpp' */

 /* Komplementarny plik nagwka */
#include "mrWindow.h"

 /* Konstruktor domylny */
mrWindow::mrWindow (void)
{
 /* Nic nie robi */
}

 /* Destruktor domylny */
mrWindow::~mrWindow (void)
{
 /* Nic nie robi */
}

 /* Tworzenie okna */
mrError32 mrWindow::Create (HINSTANCE hInstance, LPSTR szTitle, mrInt iWidth, 
                            mrInt iHeight, mrUInt32 iStyle)
{
  /* Waciwoci wizualne */
 m_kWndClass.hCursor       = LoadCursor (NULL, IDC_ARROW);
 m_kWndClass.hIcon         = LoadIcon (NULL, IDI_APPLICATION);
 m_kWndClass.hbrBackground = (HBRUSH) GetStockObject (WHITE_BRUSH);

  /* Waciwoci systemowe */
 m_kWndClass.hInstance     = hInstance;
 m_kWndClass.lpfnWndProc   = WndProc;
 m_kWndClass.lpszClassName = "Mirus Window";

  /* Waciwoci dodatkowe */
 m_kWndClass.lpszMenuName  = NULL;

 m_kWndClass.cbClsExtra = NULL;
 m_kWndClass.cbWndExtra = NULL;
 m_kWndClass.style      = NULL;

  /* Prba rejestracji klasy */
 if (!RegisterClass (&m_kWndClass))
 {
  return mrErrorRegisterClass;
 }

  /* Utworzenie okna */
 m_hWindow = CreateWindow ("Mirus Window", szTitle, iStyle, CW_USEDEFAULT,
                           CW_USEDEFAULT, iWidth, iHeight, 
                           NULL, NULL, hInstance, (void *) this);
 SetWindowText (m_hWindow, szTitle);

 return mrNoError;
}

 /* Normalny program obsugi komunikatw - przekierowuje komunikaty do naszego*/
LRESULT CALLBACK mrWindow::WndProc (HWND hWindow, UINT iMessage, 
                                    WPARAM wParam, LPARAM lParam)
{
 mrWindow * pkWindow   = NULL;
 mrBool32   bProcessed = mrFalse;

 switch (iMessage)
 {
  /* Okno jest tworzone - ustawienie informacji wasnych */
 case WM_NCCREATE:
  SetWindowLong (hWindow, GWL_USERDATA, 
                 (long)((LPCREATESTRUCT(lParam))->lpCreateParams));
  break;
  /* Komunikat okna - niech obsuy go nasz program obsugi */
 default:
   pkWindow = (mrWindow *) GetWindowLong (hWindow, GWL_USERDATA);
   if (NULL != pkWindow)
   {
    bProcessed = pkWindow->MessageHandler (iMessage, wParam, lParam);
   }
  break;
 }
   /* Komunikat nie przetworzony - niech obsuy go Windows */
 if (mrFalse == bProcessed)
 {
  return DefWindowProc (hWindow, iMessage, wParam, lParam);
 }
 return 0;
}

 /* Ptla czasu rzeczywistego */
void mrWindow::Run (void)
{
 while (1)
 {
   /* Zapytanie o oczekujce w kolejce komunikaty */
  if (PeekMessage (&m_kMessage, m_hWindow, 0, 0, PM_REMOVE))
  {
    /* Jeeli komunikat to WM_QUIT - wyjd z ptli */
   if (WM_QUIT == m_kMessage.message)
   {
    break;
   }
    /* Przetwarzaj komunikat normalnie */
   else
   {
    TranslateMessage (&m_kMessage);
    DispatchMessage (&m_kMessage);
   }
  }
    /* Brak komunikatu, wykonuj funkcje Frame */
  else
  {
   Frame ();
  }
 }
}

 /* Nasz program obsugi */
mrBool32 mrWindow::MessageHandler (UINT iMessage, WPARAM wParam, 
                                   LPARAM lParam)
{
 switch (iMessage)
 {
  /* Zamknij okno */
 case WM_CLOSE:
  PostQuitMessage (0);
  return mrTrue;
 break;
  /* Nie obsuony - niech obsuy go Windows */
 default:
  return mrFalse;
 break;
 }
}


void mrWindow::SetPosition (mrInt iX, mrInt iY)
{
  /* Ustaw pozycj okna */
 SetWindowPos(m_hWindow, HWND_TOP, iX, iY, 0, 0, SWP_NOSIZE);
}


POINT mrWindow::GetPosition (void)
{
 RECT  rcWindow;
 POINT pPosition;
  /* Pobierz pozycj okna */
 GetWindowRect (m_hWindow, &rcWindow);

 pPosition.x = rcWindow.left;
 pPosition.y = rcWindow.top;
 
 return pPosition;
}


void mrWindow::SetSize (mrInt iWidth, mrInt iHeight)
{
  /* Ustaw rozmiar okna */
 SetWindowPos(m_hWindow, HWND_TOP, 0, 0, iWidth, iHeight, SWP_NOMOVE);
}


POINT mrWindow::GetSize (void)
{
 RECT  rcWindow;
 POINT pSize;
  /* Pobierz rozmiar okna */
 GetWindowRect (m_hWindow, &rcWindow);

 pSize.x = rcWindow.right  - rcWindow.left;
 pSize.y = rcWindow.bottom - rcWindow.top;
 
 return pSize;
}


void mrWindow::Show (mrInt iShow)
{
  /* Zmie status okna (widzialne/niewidzialne) */
 ShowWindow (m_hWindow, iShow);
}



 